package futronictech.com;

import java.io.File;
import java.io.FileOutputStream;

import android.app.Activity;
import android.app.AlertDialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Bitmap.Config;
import android.graphics.Canvas;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import android.os.Bundle;
//import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.TextView;
import android.widget.Toast;


public class FS28DemoActivity extends Activity {
    /** Called when the activity is first created. */
    // Debugging
    private static final String TAG = "FS28Demo_V3.1";
    private static final boolean D = false;
    // Message types sent from the BluetoothDataService Handler
    public static final int MESSAGE_STATE_CHANGE = 1;
    public static final int MESSAGE_READ = 2;
    public static final int MESSAGE_WRITE = 3;
    public static final int MESSAGE_DEVICE_NAME = 4;
    public static final int MESSAGE_TOAST = 5;
    public static final int MESSAGE_SHOW_MSG = 6;
    public static final int MESSAGE_SHOW_IMAGE = 7;
    public static final int MESSAGE_SHOW_PROGRESSBAR = 8;
    public static final int MESSAGE_DATA_RECEIVING = 9;
    public static final int MESSAGE_DATA_ERROR = 10;
    public static final int MESSAGE_EXIT_PROGRAM = 11;
    // Key names received from the BluetoothDataService Handler
    public static final String DEVICE_NAME = "device_name";
    public static final String SHOW_MESSAGE = "show_message";
    public static final String TOAST = "toast";
    // Intent request codes
    private static final int REQUEST_CONNECT_DEVICE = 1;
    private static final int REQUEST_ENABLE_BT = 2;
    private static final int REQUEST_FILE_FORMAT = 3;
    
	private Button mButtonOpen;
	private Button mButtonSave;
	private TextView mMessage;
	private ImageView mFingerImage;
	private ProgressBar mProgressbar1;
	private RadioButton mRadioIn;
	private RadioButton mRadioOut;
    public static boolean mStop = true;
    public static boolean mConnected = false;
    public static int mStep = 0;
    public static boolean mIn = true;
    
    private String mConnectedDeviceName = null;
    // Local Bluetooth adapter
    private BluetoothAdapter mBluetoothAdapter = null;
    private BluetoothDataService mBTService = null;

    public static byte[] mImageFP = new byte[153602];    
    private static Bitmap mBitmapFP;

    public static byte[] mHostSample = new byte[669]; 
    public static byte[] mANSISample;
    public static byte[] mISOSample;
    public static byte[] mWsqImageFP;
    public static int mReceivedDataType = BluetoothDataService.DATA_TYPE_RAWIMAGE;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        // Get local Bluetooth adapter
        mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();

        // If the adapter is null, then Bluetooth is not supported
        if (mBluetoothAdapter == null) {
            Toast.makeText(this, "Bluetooth is not available", Toast.LENGTH_LONG).show();
            finish();
            return;
        }
        mMessage = (TextView) findViewById(R.id.tvMessage);
        mFingerImage = (ImageView) findViewById(R.id.imageFinger);
        mProgressbar1 = (ProgressBar) findViewById(R.id.progressBar1);     
        mProgressbar1.setMax(100);
        // Initialize the send button with a listener that for click events
        mButtonOpen = (Button) findViewById(R.id.btn_open_bt);
        mButtonSave = (Button) findViewById(R.id.btn_save);
        mRadioIn = (RadioButton) findViewById(R.id.radioIn);
        mRadioOut = (RadioButton) findViewById(R.id.radioOut);
        mButtonSave.setEnabled(false);
        //check the status of buttons from destroy
        if( !mIn )
        	mRadioOut.setChecked(true);
        	
        mButtonOpen.setOnClickListener(new OnClickListener() {
            @Override
			public void onClick(View v) {
        		if(mStop)
        		{
        			if( !mIn )
        			{
        	            startDeviceListActivity();
        			}
        			else
        			{
	        			mStop = false;        			
		        		setupCommunication();
	        	        mButtonOpen.setText("Close BT Comm");
	        	        mRadioIn.setEnabled(false);
	        	        mRadioOut.setEnabled(false);
        			}
        		}        		
        		else
        		{        		
	        		mStop = true;
        			if( mBTService != null )
        			{
        				mBTService.stop();
        				mBTService = null;
        			}        			
        			mButtonOpen.setText("Open BT Comm");
        	        mRadioIn.setEnabled(true);
        	        mRadioOut.setEnabled(true);
        		}
            }
        });
        
        mButtonSave.setOnClickListener(new OnClickListener() {
            @Override
			public void onClick(View v) {
            	SaveImage();
                }
        });
        
        mRadioIn.setOnClickListener(new OnClickListener() {
            @Override
			public void onClick(View v) {
            	mIn = true;
            }
        });
        
        mRadioOut.setOnClickListener(new OnClickListener() {
            @Override
			public void onClick(View v) {
            	mIn = false;
            }
        });        
        
    }
    
    public void startDeviceListActivity()
    {
	    Intent serverIntent = new Intent(this, DeviceListActivity.class);
	    startActivityForResult(serverIntent, REQUEST_CONNECT_DEVICE);
    }
    
    @Override
    public void onStart() {
        super.onStart();
        if(D) Log.e(TAG, "++ ON START ++");

        // If BT is not on, request that it be enabled.
        // setupChat() will then be called during onActivityResult
        if (!mBluetoothAdapter.isEnabled()) {
            Intent enableIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
            startActivityForResult(enableIntent, REQUEST_ENABLE_BT);
        }
    }

    @Override
    public synchronized void onResume() {
        super.onResume();
        if(D) Log.e(TAG, "+ ON RESUME +");

    }

    private void setupCommunication() {
        Log.d(TAG, "setupCommunication()");

        if (mBTService != null) {
            // Only if the state is STATE_NONE, do we know that we haven't started already
            if (mBTService.getState() == BluetoothDataService.STATE_NONE) {
              // Start the Bluetooth services
            	mBTService.start();
            }
        }       
        else
        {
        	mBTService = new BluetoothDataService(this, mHandler);
        	mBTService.start();
        }

    }

    @Override
    public synchronized void onPause() {
        super.onPause();
        if(D) Log.e(TAG, "- ON PAUSE -");
    }

    @Override
    public void onStop() {
        super.onStop();
        if(D) Log.e(TAG, "-- ON STOP --");
    }

    @Override
    public void onDestroy() {
	        super.onDestroy();
	        // Stop the Bluetooth services
	        mStop = true;
	        if (mBTService != null) mBTService.stop();
	        if(D) Log.e(TAG, "--- ON DESTROY ---");
    }
 
    @Override
	public void onBackPressed() {
    	//super.OnBackPressed();
        new AlertDialog.Builder(this) 
        .setTitle("Exit") 
        .setMessage("Do you want to exit this program?") 
        .setPositiveButton("Yes", new DialogInterface.OnClickListener() { 
             @Override
			public void onClick(DialogInterface dialog, int whichButton) { 
            	//send message to exit
             	mHandler.obtainMessage(MESSAGE_EXIT_PROGRAM).sendToTarget();
             } 
        }) 
        .setNegativeButton("No", new DialogInterface.OnClickListener() { 
             @Override
			public void onClick(DialogInterface dialog, int whichButton) {
             } 
        })
        .setCancelable(false)
        .show();
	}
    
    public void ExitProgram()
    {
    	onDestroy();
		System.exit(0);
    }
    private void SaveImage()
    {
	    Intent serverIntent = new Intent(this, SelectFileFormatActivity.class);
	    startActivityForResult(serverIntent, REQUEST_FILE_FORMAT);
    }
    
    private void SaveImageByFileFormat(String fileFormat, String fileName)
    {
 	   	if( fileFormat.compareTo("WSQ") == 0 )	//save wsq file
    	{    	
    		if( mWsqImageFP != null )
    		{  			
    	        File file = new File(fileName);                
    	        try { 
    	            FileOutputStream out = new FileOutputStream(file);                    
    	            out.write(mWsqImageFP, 0, mWsqImageFP.length);	// save the wsq_size bytes data to file
    	            out.close();
    	            mMessage.setText("Image is saved as " + fileName);
    	         } catch (Exception e) { 
    	        	 mMessage.setText("Exception in saving file"); 
    	         }     			
    		}
    		else
    			mMessage.setText("Invalid WSQ image!");
    		return;
    	}
 	   	else if( fileFormat.compareTo("FUTRONIC SAMPLE") == 0 )	//save Futronic fingerprint sample file
 	   	{
			File file = new File(fileName);                
			try { 
			    FileOutputStream out = new FileOutputStream(file);                    
			    out.write(mHostSample, 0, mHostSample.length);	// save the sample bytes data to file
				out.close();
				mMessage.setText("Sample is saved as " + fileName);
			 } catch (Exception e) { 
				 mMessage.setText("Exception in saving file"); 
			 }
			return;
 	   	}
 	   else if( fileFormat.compareTo("ANSI SAMPLE") == 0 )	//save ANSI fingerprint sample file
	   	{
			File file = new File(fileName);                
			try { 
			    FileOutputStream out = new FileOutputStream(file);                    
			    out.write(mANSISample, 0, mANSISample.length);	// save the sample bytes data to file
				out.close();
				mMessage.setText("Sample is saved as " + fileName);
			 } catch (Exception e) { 
				 mMessage.setText("Exception in saving file"); 
			 }
			return;
	   	}
 	  else if( fileFormat.compareTo("ISO SAMPLE") == 0 )	//save ISO fingerprint sample file
	   	{
			File file = new File(fileName);                
			try { 
			    FileOutputStream out = new FileOutputStream(file);                    
			    out.write(mISOSample, 0, mISOSample.length);	// save the sample bytes data to file
				out.close();
				mMessage.setText("Sample is saved as " + fileName);
			 } catch (Exception e) { 
				 mMessage.setText("Exception in saving file"); 
			 }
			return;
	   	}
    	// 0 - save bitmap file 
        File file = new File(fileName);                
        try { 
            FileOutputStream out = new FileOutputStream(file);                    
            MyBitmapFile fileBMP = new MyBitmapFile(320, 480, mImageFP);
            out.write(fileBMP.toBytes());
            out.close();
            mMessage.setText("Image is saved as " + fileName);
         } catch (Exception e) { 
        	 mMessage.setText("Exception in saving file"); 
         } 
    }

	// The Handler that gets information back from the BluetoothChatService
    private final Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
            case MESSAGE_STATE_CHANGE:
                switch (msg.arg1) {
                case BluetoothDataService.STATE_CONNECTED:
                    mMessage.setText("Connected ");
                    mMessage.append(mConnectedDeviceName);
                    break;
                case BluetoothDataService.STATE_CONNECTING:
                	mMessage.setText("Connecting...");
                    break;
                case BluetoothDataService.STATE_LISTEN:
                case BluetoothDataService.STATE_NONE:
                	mMessage.setText("Not connected.");
                	if( mConnected )
                	{
                		mConnected = false;
		        		if( !mStop )
		        		{
		        			if( mBTService != null )
		        			{
		        				mBTService.stop();
		        				mBTService = null;
		        			}
		        			if( mIn)
		        				setupCommunication();
		        		}
                	}
                	else
                		mButtonOpen.setEnabled(true);
                    break;
                }
                break;
            case MESSAGE_SHOW_MSG:            	
            	String showMsg = (String) msg.obj;
                mMessage.setText(showMsg);
                break;
            case MESSAGE_SHOW_PROGRESSBAR:
            	mButtonOpen.setEnabled(false);
            	mButtonSave.setEnabled(false);
            	mProgressbar1.setProgress(mStep);
                break;
            case MESSAGE_SHOW_IMAGE:
            	mProgressbar1.setProgress(0);
                if((mReceivedDataType == BluetoothDataService.DATA_TYPE_WSQIMAGE) || (mReceivedDataType == BluetoothDataService.DATA_TYPE_RAWIMAGE))
            	ShowBitmap();
                else
                mFingerImage.setImageBitmap(null);
            	mButtonSave.setEnabled(true);
            	mButtonOpen.setEnabled(true);
                break;                
            case MESSAGE_DEVICE_NAME:
                // save the connected device's name
                mConnectedDeviceName = msg.getData().getString(DEVICE_NAME);
                Toast.makeText(getApplicationContext(), "Connected to "
                               + mConnectedDeviceName, Toast.LENGTH_SHORT).show();
                break;
            case MESSAGE_TOAST:
                Toast.makeText(getApplicationContext(), msg.getData().getString(TOAST),
                               Toast.LENGTH_SHORT).show();
                break;
            case MESSAGE_DATA_RECEIVING:
            	mButtonOpen.setEnabled(false);
            	mButtonSave.setEnabled(false);
                break;
            case MESSAGE_DATA_ERROR:
            	mButtonOpen.setEnabled(true);
                switch (msg.arg1) {
                case BluetoothDataService.ERROR_TIMEOUT:
                	mStep = 0;
                	mProgressbar1.setProgress(0);
                    mMessage.setText("Time out to receive data!");
                    try {
						Thread.sleep(1000);
					} catch (InterruptedException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
                	if( mConnected )
                	{
                		mConnected = false;
		        		if( !mStop )
		        		{
		        			if( mBTService != null )
		        			{
		        				mBTService.stop();
		        				mBTService = null;
		        			}
		        			if( mIn )
		        				setupCommunication();
		        			else
		        			{
		        				mStop = true;
		            			mButtonOpen.setText("Open BT Comm");
		            	        mRadioIn.setEnabled(true);
		            	        mRadioOut.setEnabled(true);		        				
		        			}
		        		}
                	}                	                   
                    break;
                case BluetoothDataService.ERROR_INVALID_COMMAND_DATA:
                	mMessage.setText("Invalid command data.");
                    break;
                case BluetoothDataService.ERROR_CHECKSUM_ERROR:
                	mMessage.setText("Checksum error.");
                	break;
                case BluetoothDataService.ERROR_UNKNOWN_COMMAND:
                	mMessage.setText("Unknown command.");
                	break;
                case BluetoothDataService.ERROR_IMAGE_SIZE_TOO_LARGE:
                	mMessage.setText("Image size is too large. > 153602");
                	break;               	
                }            	
                break;          
            case MESSAGE_EXIT_PROGRAM:
            	ExitProgram();
            	break;
            }
        }
    };
    
    private void ShowBitmap()
    {
    	/*if( mReceivedDataType == BluetoothDataService.DATA_TYPE_FT_SAMPLE )
    	{
    		mFingerImage.setImageBitmap(null);
    		return;
    	}*/
    	int[] pixels = new int[153600];
    	for( int i=0; i<153600; i++)
    		pixels[i] = mImageFP[i];
    	Bitmap emptyBmp = Bitmap.createBitmap(pixels, 320, 480, Config.RGB_565);

        int width, height; 
        height = emptyBmp.getHeight(); 
        width = emptyBmp.getWidth();     
     
        mBitmapFP = Bitmap.createBitmap(width, height, Bitmap.Config.RGB_565); 
        Canvas c = new Canvas(mBitmapFP); 
        Paint paint = new Paint(); 
        ColorMatrix cm = new ColorMatrix(); 
        cm.setSaturation(0); 
        ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm); 
        paint.setColorFilter(f); 
        c.drawBitmap(emptyBmp, 0, 0, paint); 
        
        mFingerImage.setImageBitmap(mBitmapFP);
    }

    @Override
	public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if(D) Log.d(TAG, "onActivityResult " + resultCode);
        switch (requestCode) {
         case REQUEST_ENABLE_BT:
            // When the request to enable Bluetooth returns
            if (resultCode == Activity.RESULT_OK) {
                // Bluetooth is now enabled, so set up a session
                //setupCommunication();
            } else {
                // User did not enable Bluetooth or an error occured
                Log.d(TAG, "BT not enabled");
                Toast.makeText(this, "BT not enabled", Toast.LENGTH_SHORT).show();
                finish();
            }
            break;
		 case REQUEST_CONNECT_DEVICE:
		     // When DeviceListActivity returns with a device to connect
			 if (resultCode == Activity.RESULT_OK) {
			     // Get the device MAC address
				 String address = data.getExtras()
				                      .getString(DeviceListActivity.EXTRA_DEVICE_ADDRESS);
                 mStop = false;        			
				 setupCommunication();
				 mButtonOpen.setText("Close BT Comm");
				 mRadioIn.setEnabled(false);
				 mRadioOut.setEnabled(false);				 
                 // Get the BLuetoothDevice object
                 BluetoothDevice device = mBluetoothAdapter.getRemoteDevice(address);
                 // Attempt to connect to the device
                 mBTService.connect(device);
             }
			 else
				 mMessage.setText("Not connected");
             break;            
	    case REQUEST_FILE_FORMAT:
			 if (resultCode == Activity.RESULT_OK) {
			     // Get the file format
				 String[] extraString = data.getExtras().getStringArray(SelectFileFormatActivity.EXTRA_FILE_FORMAT);
				 String fileFormat = extraString[0];
				 String fileName = extraString[1];
				 SaveImageByFileFormat(fileFormat, fileName);
	        }
			 else
				 mMessage.setText("Cancelled!");
	        break;            
        }        
    }
}